/*

  Macro_Scripts File
Purposes:  
    
	define actions for the viewport shading manager introduced in 3ds max 10

Revision History
	March 2007: Neil Hazzard
	created for 3ds MAX 10
*/

-- Macro Scripts for IViewportShadingMgr
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
--***********************************************************************************************
MacroScript Viewport_Shading_Display_Selected_Lights
            ButtonText:~VIEWPORT_SHADING_DISPLAY_SELECTED_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_DISPLAY_SELECTED_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_DISPLAY_SELECTED_LIGHTS_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.DisplayOnlySelectedLights()
)

MacroScript Viewport_Shading_Toggle_Selected_Lights
            ButtonText:~VIEWPORT_SHADING_TOGGLE_SELECTED_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_TOGGLE_SELECTED_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_TOGGLE_SELECTED_LIGHTS_TOOLTIP~ 
(
	on ischecked do 
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			return (viewportViewSetting.AutoDisplaySelectedLightEnabled == true)
		)
		else
		(
			return IViewportShadingMgr.AutoDisplaySelLights
		)
	)
	on isEnabled do 
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			bShaded = (viewportViewSetting.VisualStyleMode == #Shaded)
			bWireframe = (viewportViewSetting.VisualStyleMode == #Wireframe)
			bBoundingBox = (viewportViewSetting.VisualStyleMode == #BoundingBox)
			if bShaded or bWireframe or bBoundingBox then
				return false
			else
				return true
		)
		else
		(
			bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
			viewSettings = maxops.GetViewportShadingSettings()
			bHWEnabled = viewSettings.ActivateViewportShading
			return (bHWSupported == true and bHWEnabled == true)
		)
	)
	On Execute Do
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			Try (viewportViewSetting.AutoDisplaySelectedLightEnabled = (not viewportViewSetting.AutoDisplaySelectedLightEnabled))
			catch()	
		)
		else
		(
			Try (IViewportShadingMgr.AutoDisplaySelLights  = (not IViewportShadingMgr.AutoDisplaySelLights ))	
			catch()
		)
	)
)

MacroScript Viewport_Shading_Lock_Selected_Lights
            ButtonText:~VIEWPORT_SHADING_LOCK_SELECTED_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_LOCK_SELECTED_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_LOCK_SELECTED_LIGHTS_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.LockSelectedLights true
	
	on isEnabled do 
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			bShaded = (viewportViewSetting.VisualStyleMode == #Shaded)
			bWireframe = (viewportViewSetting.VisualStyleMode == #Wireframe)
			bBoundingBox = (viewportViewSetting.VisualStyleMode == #BoundingBox)
			if bShaded or bWireframe or bBoundingBox then
				return false
			else
				return true
		)
		else
		(
			bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
			viewSettings = maxops.GetViewportShadingSettings()
			bHWEnabled = viewSettings.ActivateViewportShading
			return (bHWSupported == true and bHWEnabled == true)
		)
	)	
)

MacroScript Viewport_Shading_Unlock_Selected_Lights
            ButtonText:~VIEWPORT_SHADING_UNLOCK_SELECTED_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_UNLOCK_SELECTED_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_UNLOCK_SELECTED_LIGHTS_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.LockSelectedLights false
	on isEnabled do 
	(
		if NitrousGraphicsManager.IsEnabled() ==true then
		(
			viewportViewSetting = NitrousGraphicsManager.GetActiveViewportSetting()
			bShaded = (viewportViewSetting.VisualStyleMode == #Shaded)
			bWireframe = (viewportViewSetting.VisualStyleMode == #Wireframe)
			bBoundingBox = (viewportViewSetting.VisualStyleMode == #BoundingBox)
			if bShaded or bWireframe or bBoundingBox then
				return false
			else
				return true
		)
		else
		(
			bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
			viewSettings = maxops.GetViewportShadingSettings()
			bHWEnabled = viewSettings.ActivateViewportShading
			return (bHWSupported == true and bHWEnabled == true)
		)
	)	
)

MacroScript Viewport_Shading_Select_Illuminating_Lights
            ButtonText:~VIEWPORT_SHADING_SELECT_ILLUMINATING_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_SELECT_ILLUMINATING_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_SELECT_ILLUMINATING_LIGHTS_TOOLTIP~  
(
	On Execute Do IViewportShadingMgr.SelectIlluminatingLights()
	on isEnabled do 
	(
		bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
		viewSettings = maxops.GetViewportShadingSettings()
		bHWEnabled = viewSettings.ActivateViewportShading
		return (bHWSupported == true and bHWEnabled == true)
	)	
)

MacroScript Viewport_Shading_Select_Shadow_Casting_Lights
            ButtonText:~VIEWPORT_SHADING_SELECT_SHADOW_CASTING_LIGHTS_BUTTONTEXT~
            category:~VIEWPORT_SHADING_SELECT_SHADOW_CASTING_LIGHTS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_SELECT_SHADOW_CASTING_LIGHTS_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.SelectShadowCastingLights()
	on isEnabled do 
	(
		bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
		viewSettings = maxops.GetViewportShadingSettings()
		bHWEnabled = viewSettings.ActivateViewportShading
		return (bHWSupported == true and bHWEnabled == true)
	)	
)

MacroScript Viewport_Shading_Enable_Shadows_Selected
            ButtonText:~VIEWPORT_SHADING_ENABLE_SHADOWS_SELECTED_BUTTONTEXT~
            category:~VIEWPORT_SHADING_ENABLE_SHADOWS_SELECTED_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_ENABLE_SHADOWS_SELECTED_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.CastShadowsSelectedOnly true
	on isEnabled do 
	(
		bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
		viewSettings = maxops.GetViewportShadingSettings()
		bHWEnabled = viewSettings.ActivateViewportShading
		return (bHWSupported == true and bHWEnabled == true)
	)	
)

MacroScript Viewport_Shading_Disable_Shadows_Selected
            ButtonText:~VIEWPORT_SHADING_DISABLE_SHADOWS_SELECTED_BUTTONTEXT~
            category:~VIEWPORT_SHADING_DISABLE_SHADOWS_SELECTED_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_SHADING_DISABLE_SHADOWS_SELECTED_TOOLTIP~ 
(
	On Execute Do IViewportShadingMgr.CastShadowsSelectedOnly false
	on isEnabled do 
	(
		bHWSupported = IviewportShadingMgr.IsShadingLimitValid #Good 
		viewSettings = maxops.GetViewportShadingSettings()
		bHWEnabled = viewSettings.ActivateViewportShading
		return (bHWSupported == true and bHWEnabled == true)
	)	
)

MacroScript Viewport_GPU_Diagnostics
            ButtonText:~VIEWPORT_GPU_DIAGNOSTICS_BUTTONTEXT~
            category:~VIEWPORT_GPU_DIAGNOSTICS_CATEGORY~
            internalCategory:"Viewport Lighting and Shadows"
            Tooltip:~VIEWPORT_GPU_DIAGNOSTICS_TOOLTIP~ 
(
	On Execute Do
	(
		if (classof(renderers.current) == mental_ray_iray_renderer) do
		(
			setListenerSelText renderers.current.hardwareReport
			setListenerSelText "\n\n"
		)
		-- Alwasy print the OGS diagnostics
		setListenerSelText OGSDiagnostics.hardwareReport

		if NitrousGraphicsManager.isEnabled() != true do
			IViewportShadingMgr.ReviewGPUDiagnostics()
	)
)
